#include <inttypes.h>
#ifdef __AVR__
#include <avr/pgmspace.h>
#elif defined (ESP8266)
#include <pgmspace.h>
#else
#define PROGMEM
#endif

#ifndef UTF8FONT10x15_H
#define UTF8FONT10x15_H

#define UTF8FONT10x15_WIDTH 10
#define UTF8FONT10x15_HEIGHT 15

static const uint8_t utf8font10x16[] PROGMEM = {
    0x39, 0x31, // size
    0x0A, // width
    0x0f, // height (does not include pad pixel between lines)
    0x20, // first char
    0xDC, // char count
    
    // char widths
    0x02, 0x02, 0x05, 0x05, 0x05, 0x08, 0x07, 0x02, 
    0x03, 0x02, 0x03, 0x06, 0x02, 0x03, 0x02, 0x03, 
    0x05, 0x03, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
    0x05, 0x05, 0x02, 0x02, 0x06, 0x06, 0x06, 0x05, 
    0x0A, 0x06, 0x06, 0x06, 0x06, 0x05, 0x05, 0x06, 
    0x06, 0x02, 0x04, 0x06, 0x05, 0x07, 0x06, 0x07, 
    0x06, 0x08, 0x07, 0x06, 0x06, 0x06, 0x06, 0x08, 
    0x07, 0x06, 0x05, 0x03, 0x03, 0x02, 0x05, 0x05, 
    0x02, 0x04, 0x05, 0x04, 0x05, 0x04, 0x03, 0x05, 
    0x05, 0x02, 0x02, 0x05, 0x02, 0x08, 0x05, 0x05, 
    0x05, 0x05, 0x04, 0x04, 0x03, 0x05, 0x05, 0x07, 
    0x05, 0x05, 0x04, 0x03, 0x02, 0x04, 0x06, 0x02, 
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
    0x00, 0x02, 0x05, 0x06, 0x05, 0x06, 0x02, 0x04, 
    0x03, 0x07, 0x03, 0x05, 0x05, 0x03, 0x07, 0x06, 
    0x04, 0x06, 0x03, 0x03, 0x02, 0x05, 0x05, 0x01, 
    0x03, 0x02, 0x03, 0x05, 0x08, 0x08, 0x08, 0x05, 
    0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0A, 0x06, 
    0x05, 0x05, 0x06, 0x05, 0x02, 0x02, 0x03, 0x02, 
    0x06, 0x06, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 
    0x07, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
    0x04, 0x04, 0x05, 0x04, 0x04, 0x04, 0x08, 0x04, 
    0x04, 0x04, 0x05, 0x04, 0x02, 0x02, 0x03, 0x02, 
    0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x06, 
    0x05, 0x05, 0x05, 0x05, 
    
    // font data
    0x00, 0x00, 0x00, 0x00, // 0x20 <space>
    0xF8, 0xF8, 0x16, 0x16, // 33
    0x38, 0x38, 0x00, 0x38, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, // 34
    0x20, 0xE0, 0x38, 0xE0, 0x38, 0x1C, 0x06, 0x1C, 0x06, 0x04, // 35
    0x70, 0xC8, 0xFC, 0x88, 0x10, 0x0C, 0x18, 0x3E, 0x12, 0x0E, // 36
    0x78, 0x48, 0x78, 0x80, 0x60, 0x18, 0x00, 0x00, 0x00, 0x00, 0x18, 0x06, 0x00, 0x1E, 0x12, 0x1E, // 37
    0x00, 0xB0, 0xF8, 0xC8, 0x78, 0x30, 0x00, 0x0E, 0x1E, 0x12, 0x12, 0x1E, 0x1C, 0x0A, // 38
    0x38, 0x38, 0x00, 0x00, // 39
    0xC0, 0xF0, 0x18, 0x0E, 0x3E, 0x60, // 40
    0xF0, 0xC0, 0x3E, 0x0E, // 41
    0x50, 0x38, 0x50, 0x00, 0x00, 0x00, // 42
    0x80, 0x80, 0xE0, 0xE0, 0x80, 0x80, 0x02, 0x02, 0x0E, 0x0E, 0x02, 0x02, // 43
    0x00, 0x00, 0x50, 0x30, // 44
    0x00, 0x00, 0x00, 0x04, 0x04, 0x04, // 45
    0x00, 0x00, 0x10, 0x10, // 46
    0x80, 0xF8, 0xF8, 0x1E, 0x1E, 0x00, // 47
    0xF0, 0xF8, 0x08, 0xF8, 0xF0, 0x0E, 0x1E, 0x10, 0x1E, 0x0E, // 48
    0x60, 0xF0, 0xF8, 0x00, 0x1E, 0x1E, // 49
    0x10, 0x18, 0x88, 0xF8, 0xF0, 0x18, 0x1E, 0x16, 0x12, 0x10, // 50
    0x10, 0x18, 0x88, 0xF8, 0x70, 0x08, 0x18, 0x10, 0x1E, 0x0E, // 51
    0x80, 0x60, 0xF8, 0xF8, 0x00, 0x06, 0x04, 0x1E, 0x1E, 0x04, // 52
    0xC0, 0x78, 0x48, 0xC8, 0x88, 0x08, 0x18, 0x10, 0x1E, 0x0E, // 53
    0xE0, 0xF8, 0x48, 0xD8, 0x90, 0x0E, 0x1E, 0x10, 0x1E, 0x0E, // 54
    0x08, 0x08, 0xE8, 0xF8, 0x18, 0x00, 0x1E, 0x1E, 0x00, 0x00, // 55
    0x70, 0x78, 0x88, 0x78, 0x70, 0x0E, 0x1E, 0x10, 0x1E, 0x0E, // 56
    0xF0, 0xF8, 0x08, 0xF8, 0xF0, 0x08, 0x1A, 0x12, 0x1E, 0x06, // 57
    0x40, 0x40, 0x10, 0x10, // 58
    0x40, 0x40, 0x50, 0x30, // 59
    0x80, 0x80, 0xC0, 0xC0, 0xC0, 0x60, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x18, // 60
    0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, // 61
    0x60, 0xC0, 0xC0, 0xC0, 0x80, 0x80, 0x18, 0x0C, 0x0C, 0x0C, 0x06, 0x06, // 62
    0x10, 0x18, 0x88, 0xF8, 0xF0, 0x00, 0x00, 0x16, 0x16, 0x00, // 63
    0xC0, 0x20, 0x10, 0x88, 0x48, 0x48, 0x48, 0xD8, 0x30, 0xE0, 0x0E, 0x30, 0x2E, 0x50, 0x50, 0x50, 0x5E, 0x50, 0x28, 0x16, // 64
    0x00, 0xE0, 0x38, 0x38, 0xE0, 0x00, 0x1C, 0x1E, 0x02, 0x02, 0x1E, 0x1C, // 65
    0xF8, 0xF8, 0x88, 0x88, 0xF8, 0x70, 0x1E, 0x1E, 0x10, 0x10, 0x1E, 0x0E, // 66
    0xF0, 0xF8, 0x08, 0x08, 0x18, 0x10, 0x0E, 0x1E, 0x10, 0x10, 0x1C, 0x0C, // 67
    0xF8, 0xF8, 0x08, 0x08, 0xF8, 0xF0, 0x1E, 0x1E, 0x10, 0x10, 0x1E, 0x0E, // 68
    0xF8, 0xF8, 0x88, 0x88, 0x88, 0x1E, 0x1E, 0x10, 0x10, 0x10, // 69
    0xF8, 0xF8, 0x88, 0x88, 0x88, 0x1E, 0x1E, 0x00, 0x00, 0x00, // 70
    0xF0, 0xF8, 0x08, 0x88, 0x98, 0x90, 0x0E, 0x1E, 0x10, 0x10, 0x1E, 0x0E, // 71
    0xF8, 0xF8, 0x80, 0x80, 0xF8, 0xF8, 0x1E, 0x1E, 0x00, 0x00, 0x1E, 0x1E, // 72
    0xF8, 0xF8, 0x1E, 0x1E, // 73
    0x00, 0x00, 0xF8, 0xF8, 0x0C, 0x10, 0x1E, 0x0E, // 74
    0xF8, 0xF8, 0xC0, 0xF0, 0xB8, 0x08, 0x1E, 0x1E, 0x00, 0x02, 0x1E, 0x1C, // 75
    0xF8, 0xF8, 0x00, 0x00, 0x00, 0x1E, 0x1E, 0x10, 0x10, 0x10, // 76
    0xF8, 0xF8, 0xC0, 0x00, 0xC0, 0xF8, 0xF8, 0x1E, 0x1E, 0x02, 0x1E, 0x00, 0x1E, 0x1E, // 77
    0xF8, 0xF8, 0xF0, 0x80, 0xF8, 0xF8, 0x1E, 0x1E, 0x00, 0x0E, 0x1E, 0x1E, // 78
    0xE0, 0xF0, 0x18, 0x08, 0x18, 0xF0, 0xE0, 0x06, 0x0E, 0x18, 0x10, 0x18, 0x0E, 0x06, // 79
    0xF8, 0xF8, 0x08, 0x08, 0xF8, 0xF0, 0x1E, 0x1E, 0x02, 0x02, 0x02, 0x00, // 80
    0xE0, 0xF0, 0x18, 0x08, 0x18, 0xF0, 0xE0, 0x00, 0x06, 0x0E, 0x18, 0x14, 0x18, 0x1E, 0x3E, 0x30, // 81
    0xF8, 0xF8, 0x88, 0x88, 0xF8, 0x70, 0x00, 0x1E, 0x1E, 0x00, 0x02, 0x0E, 0x1C, 0x10, // 82
    0x70, 0xF8, 0xC8, 0x88, 0xB8, 0x30, 0x0C, 0x1C, 0x10, 0x12, 0x1E, 0x0E, // 83
    0x08, 0x08, 0xF8, 0xF8, 0x08, 0x08, 0x00, 0x00, 0x1E, 0x1E, 0x00, 0x00, // 84
    0xF8, 0xF8, 0x00, 0x00, 0xF8, 0xF8, 0x0E, 0x1E, 0x10, 0x10, 0x1E, 0x0E, // 85
    0x38, 0xF8, 0x80, 0x80, 0xF8, 0x38, 0x00, 0x06, 0x1E, 0x1E, 0x06, 0x00, // 86
    0xF8, 0xF8, 0x00, 0xF8, 0xF8, 0x00, 0xF8, 0xF8, 0x06, 0x1E, 0x1C, 0x02, 0x06, 0x18, 0x1E, 0x06, // 87
    0x08, 0x38, 0xF0, 0xC0, 0xF0, 0x38, 0x08, 0x10, 0x1C, 0x0E, 0x06, 0x0E, 0x1C, 0x10, // 88
    0x18, 0x78, 0xE0, 0xE0, 0x78, 0x18, 0x00, 0x00, 0x1E, 0x1E, 0x00, 0x00, // 89
    0x08, 0x88, 0xE8, 0x78, 0x18, 0x18, 0x1E, 0x16, 0x10, 0x10, // 90
    0xF8, 0xF8, 0x08, 0x7E, 0x7E, 0x40, // 91
    0xF8, 0xF8, 0x80, 0x00, 0x1E, 0x1E, // 92
    0xF8, 0xF8, 0x7E, 0x7E, // 93
    0xE0, 0xF8, 0x18, 0xF8, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, // 94
    0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x40, 0x40, // 95
    0x08, 0x18, 0x00, 0x00, // 96
    0x40, 0x40, 0xC0, 0x80, 0x1C, 0x12, 0x1E, 0x1E, // 97
    0xF8, 0xF8, 0x40, 0xC0, 0x80, 0x1E, 0x1E, 0x10, 0x1E, 0x0E, // 98
    0x80, 0xC0, 0x40, 0x80, 0x0E, 0x1E, 0x10, 0x08, // 99
    0x80, 0xC0, 0x40, 0xF8, 0xF8, 0x0E, 0x1E, 0x10, 0x1E, 0x1E, // 100
    0x80, 0xC0, 0x40, 0x80, 0x0E, 0x1E, 0x12, 0x0A, // 101
    0xF0, 0xF8, 0x48, 0x1E, 0x1E, 0x00, // 102
    0x80, 0xC0, 0x40, 0xC0, 0xC0, 0x2E, 0x7E, 0x50, 0x7E, 0x3E, // 103
    0xF8, 0xF8, 0x40, 0xC0, 0x80, 0x1E, 0x1E, 0x00, 0x1E, 0x1E, // 104
    0xD8, 0xD8, 0x1E, 0x1E, // 105
    0xD8, 0xD8, 0x7E, 0x3E, // 106
    0xF8, 0xF8, 0x80, 0xC0, 0x00, 0x1E, 0x1E, 0x06, 0x1E, 0x18, // 107
    0xF8, 0xF8, 0x1E, 0x1E, // 108
    0xC0, 0xC0, 0x40, 0xC0, 0x80, 0x40, 0xC0, 0x80, 0x1E, 0x1E, 0x00, 0x1E, 0x1E, 0x00, 0x1E, 0x1E, // 109
    0xC0, 0xC0, 0x40, 0xC0, 0x80, 0x1E, 0x1E, 0x00, 0x1E, 0x1E, // 110
    0x80, 0xC0, 0x40, 0xC0, 0x80, 0x0E, 0x1E, 0x10, 0x1E, 0x0E, // 111
    0xC0, 0xC0, 0x40, 0xC0, 0x80, 0x7E, 0x7E, 0x10, 0x1E, 0x0E, // 112
    0x80, 0xC0, 0x40, 0xC0, 0xC0, 0x0E, 0x1E, 0x10, 0x7E, 0x7E, // 113
    0xC0, 0xC0, 0x40, 0x40, 0x1E, 0x1E, 0x00, 0x00, // 114
    0x80, 0xC0, 0x40, 0x80, 0x0A, 0x12, 0x1E, 0x0E, // 115
    0xE0, 0xF0, 0x40, 0x0E, 0x1E, 0x10, // 116
    0xC0, 0xC0, 0x00, 0xC0, 0xC0, 0x0E, 0x1E, 0x10, 0x1E, 0x1E, // 117
    0xC0, 0xC0, 0x00, 0xC0, 0xC0, 0x00, 0x1E, 0x18, 0x1E, 0x00, // 118
    0xC0, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0xC0, 0x02, 0x1E, 0x1C, 0x02, 0x1C, 0x1E, 0x02, // 119
    0x40, 0xC0, 0x00, 0xC0, 0x40, 0x10, 0x1A, 0x06, 0x18, 0x10, // 120
    0xC0, 0xC0, 0x00, 0xC0, 0xC0, 0x40, 0x4E, 0x3C, 0x0E, 0x00, // 121
    0x40, 0x40, 0xC0, 0xC0, 0x18, 0x1E, 0x16, 0x10, // 122
    0xF0, 0xF8, 0x08, 0x3E, 0x7C, 0x40, // 123
    0xF8, 0xF8, 0x7E, 0x7E, // 124
    0x08, 0xF8, 0xF0, 0x00, 0x40, 0x7C, 0x3E, 0x02, // 125
    0x80, 0x80, 0x80, 0x00, 0x00, 0x80, 0x02, 0x00, 0x00, 0x02, 0x02, 0x02, // 126
    0xF0, 0xF0, 0x1E, 0x1E, // 127
    0xF0, 0xF0, 0x1E, 0x1E, // 128
    0xF0, 0xF0, 0x1E, 0x1E, // 129
    0xF0, 0xF0, 0x1E, 0x1E, // 130
    0xF0, 0xF0, 0x1E, 0x1E, // 131
    0xF0, 0xF0, 0x1E, 0x1E, // 132
    0xF0, 0xF0, 0x1E, 0x1E, // 133
    0xF0, 0xF0, 0x1E, 0x1E, // 134
    0xF0, 0xF0, 0x1E, 0x1E, // 135
    0xF0, 0xF0, 0x1E, 0x1E, // 136
    0xF0, 0xF0, 0x1E, 0x1E, // 137
    0xF0, 0xF0, 0x1E, 0x1E, // 138
    0xF0, 0xF0, 0x1E, 0x1E, // 139
    0xF0, 0xF0, 0x1E, 0x1E, // 140
    0xF0, 0xF0, 0x1E, 0x1E, // 141
    0xF0, 0xF0, 0x1E, 0x1E, // 142
    0xF0, 0xF0, 0x1E, 0x1E, // 143
    0xF0, 0xF0, 0x1E, 0x1E, // 144
    0xF0, 0xF0, 0x1E, 0x1E, // 145
    0xF0, 0xF0, 0x1E, 0x1E, // 146
    0xF0, 0xF0, 0x1E, 0x1E, // 147
    0xF0, 0xF0, 0x1E, 0x1E, // 148
    0xF0, 0xF0, 0x1E, 0x1E, // 149
    0xF0, 0xF0, 0x1E, 0x1E, // 150
    0xF0, 0xF0, 0x1E, 0x1E, // 151
    0xF0, 0xF0, 0x1E, 0x1E, // 152
    0xF0, 0xF0, 0x1E, 0x1E, // 153
    0xF0, 0xF0, 0x1E, 0x1E, // 154
    0xF0, 0xF0, 0x1E, 0x1E, // 155
    0xF0, 0xF0, 0x1E, 0x1E, // 156
    0xF0, 0xF0, 0x1E, 0x1E, // 157
    0xF0, 0xF0, 0x1E, 0x1E, // 158
    0xF0, 0xF0, 0x1E, 0x1E, // 159
    0x40, 0x40, 0x7E, 0x7E, // 161
    0x80, 0xC0, 0xC0, 0xF8, 0x80, 0x0E, 0x7E, 0x1E, 0x18, 0x08, // 162
    0x80, 0xF0, 0xF8, 0x88, 0x18, 0x10, 0x18, 0x1E, 0x16, 0x10, 0x10, 0x10, // 163
    0x20, 0xF0, 0x20, 0x20, 0xF0, 0x04, 0x0E, 0x04, 0x04, 0x0E, // 164
    0x88, 0xF8, 0xE0, 0xE0, 0xF8, 0x88, 0x04, 0x04, 0x1E, 0x1E, 0x04, 0x04, // 165
    0xF8, 0xF8, 0x7C, 0x7C, // 166
    0xB0, 0x48, 0xC8, 0x90, 0x26, 0x4C, 0x48, 0x36, // 167
    0x10, 0x00, 0x10, 0x00, 0x00, 0x00, // 168
    0xE0, 0x10, 0xC8, 0x28, 0x48, 0x10, 0xE0, 0x06, 0x08, 0x12, 0x14, 0x12, 0x08, 0x06, // 169
    0x68, 0x68, 0x78, 0x00, 0x00, 0x00, // 170
    0xC0, 0x40, 0x00, 0xC0, 0x40, 0x0E, 0x18, 0x02, 0x0E, 0x18, // 171
    0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x00, 0x00, 0x00, 0x0E, 0x0E, // 172
    0x00, 0x00, 0x00, 0x04, 0x04, 0x04, // 173
    0xE0, 0x10, 0xE8, 0xA8, 0x68, 0x10, 0xE0, 0x06, 0x08, 0x16, 0x10, 0x16, 0x08, 0x06, // 174
    0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 175
    0x30, 0x48, 0x48, 0x30, 0x00, 0x00, 0x00, 0x00, // 176
    0x60, 0x60, 0xF8, 0xF8, 0x60, 0x60, 0x18, 0x18, 0x1A, 0x1A, 0x18, 0x18, // 177
    0x48, 0x68, 0x58, 0x00, 0x00, 0x00, // 178
    0x48, 0x58, 0x78, 0x00, 0x00, 0x00, // 179
    0x18, 0x08, 0x00, 0x00, // 180
    0xC0, 0xC0, 0x00, 0xC0, 0xC0, 0x7E, 0x7E, 0x10, 0x1E, 0x1E, // 181
    0xF0, 0xF8, 0x08, 0xF8, 0x08, 0x00, 0x7E, 0x00, 0x7E, 0x00, // 182
    0x00, 0x02, // 183
    0x00, 0x00, 0x00, 0xA0, 0xA0, 0xE0, // 184
    0x10, 0x78, 0x00, 0x00, // 185
    0x78, 0x48, 0x78, 0x00, 0x00, 0x00, // 186
    0xC0, 0x80, 0x00, 0xC0, 0x80, 0x10, 0x1E, 0x04, 0x10, 0x1E, // 187
    0x10, 0x78, 0x00, 0x80, 0x40, 0x30, 0x08, 0x00, 0x00, 0x10, 0x0C, 0x02, 0x00, 0x0C, 0x1E, 0x08, // 188
    0x10, 0x78, 0x00, 0x80, 0x40, 0x30, 0x08, 0x00, 0x00, 0x10, 0x0C, 0x02, 0x00, 0x12, 0x1A, 0x16, // 189
    0x48, 0x58, 0x78, 0x80, 0x40, 0x30, 0x08, 0x00, 0x00, 0x10, 0x0C, 0x02, 0x00, 0x0C, 0x1E, 0x08, // 190
    0x00, 0x40, 0x40, 0x00, 0x00, 0x38, 0x7E, 0x46, 0x60, 0x20, // 191
    0x00, 0xE0, 0x39, 0x3B, 0xE0, 0x00, 0x1C, 0x1E, 0x02, 0x02, 0x1E, 0x1C, // 192
    0x00, 0xE0, 0x3B, 0x39, 0xE0, 0x00, 0x1C, 0x1E, 0x02, 0x02, 0x1E, 0x1C, // 193
    0x00, 0xE2, 0x3B, 0x39, 0xE3, 0x02, 0x1C, 0x1E, 0x02, 0x02, 0x1E, 0x1C, // 194
    0x00, 0xE3, 0x39, 0x3A, 0xE3, 0x00, 0x1C, 0x1E, 0x02, 0x02, 0x1E, 0x1C, // 195
    0x00, 0xE2, 0x38, 0x3A, 0xE0, 0x00, 0x1C, 0x1E, 0x02, 0x02, 0x1E, 0x1C, // 196
    0x00, 0xE0, 0x3B, 0x3B, 0xE0, 0x00, 0x1C, 0x1E, 0x02, 0x02, 0x1E, 0x1C, // 197
    0x00, 0xE0, 0xF8, 0x98, 0xF8, 0xF8, 0x48, 0x48, 0x48, 0x48, 0x1E, 0x0E, 0x00, 0x00, 0x1E, 0x1E, 0x10, 0x10, 0x10, 0x10, // 198
    0xF0, 0xF8, 0x08, 0x08, 0x18, 0x10, 0x0E, 0xBE, 0xB0, 0xF0, 0x1C, 0x0C, // 199
    0xF8, 0xF9, 0x8B, 0x88, 0x88, 0x1E, 0x1E, 0x10, 0x10, 0x10, // 200
    0xF8, 0xF8, 0x8B, 0x89, 0x88, 0x1E, 0x1E, 0x10, 0x10, 0x10, // 201
    0xF8, 0xFA, 0x8B, 0x89, 0x8B, 0x02, 0x1E, 0x1E, 0x10, 0x10, 0x10, 0x00, // 202
    0xF8, 0xFA, 0x88, 0x8A, 0x88, 0x1E, 0x1E, 0x10, 0x10, 0x10, // 203
    0xF9, 0xFB, 0x1E, 0x1E, // 204
    0xFB, 0xF9, 0x1E, 0x1E, // 205
    0xFB, 0xF9, 0x03, 0x1E, 0x1E, 0x00, // 206
    0xF8, 0xFA, 0x1E, 0x1E, // 207
    0xF8, 0xF8, 0x88, 0x08, 0xF8, 0xF0, 0x1E, 0x1E, 0x10, 0x10, 0x1E, 0x0E, // 208
    0xF8, 0xFB, 0xF1, 0x82, 0xFB, 0xF8, 0x1E, 0x1E, 0x00, 0x0E, 0x1E, 0x1E, // 209
    0xE0, 0xF0, 0x18, 0x09, 0x1B, 0xF0, 0xE0, 0x06, 0x0E, 0x18, 0x10, 0x18, 0x0E, 0x06, // 210
    0xE0, 0xF0, 0x1B, 0x09, 0x18, 0xF0, 0xE0, 0x06, 0x0E, 0x18, 0x10, 0x18, 0x0E, 0x06, // 211
    0xE0, 0xF2, 0x1B, 0x09, 0x1B, 0xF2, 0xE0, 0x06, 0x0E, 0x18, 0x10, 0x18, 0x0E, 0x06, // 212
    0xE0, 0xF3, 0x19, 0x0A, 0x1B, 0xF0, 0xE0, 0x06, 0x0E, 0x18, 0x10, 0x18, 0x0E, 0x06, // 213
    0xE0, 0xF0, 0x1A, 0x08, 0x1A, 0xF0, 0xE0, 0x06, 0x0E, 0x18, 0x10, 0x18, 0x0E, 0x06, // 214
    0x40, 0xE0, 0x80, 0xE0, 0x40, 0x04, 0x0E, 0x02, 0x0E, 0x04, // 215
    0xE0, 0xF0, 0x18, 0xC8, 0x78, 0xF0, 0xE8, 0x16, 0x0E, 0x1E, 0x12, 0x18, 0x0E, 0x06, // 216
    0xF8, 0xF8, 0x01, 0x03, 0xF8, 0xF8, 0x0E, 0x1E, 0x10, 0x10, 0x1E, 0x0E, // 217
    0xF8, 0xF8, 0x03, 0x01, 0xF8, 0xF8, 0x0E, 0x1E, 0x10, 0x10, 0x1E, 0x0E, // 218
    0xF8, 0xFA, 0x03, 0x01, 0xFB, 0xFA, 0x0E, 0x1E, 0x10, 0x10, 0x1E, 0x0E, // 219
    0xF8, 0xFA, 0x00, 0x02, 0xF8, 0xF8, 0x0E, 0x1E, 0x10, 0x10, 0x1E, 0x0E, // 220
    0x18, 0x78, 0xE3, 0xE1, 0x78, 0x18, 0x00, 0x00, 0x1E, 0x1E, 0x00, 0x00, // 221
    0xF8, 0xF8, 0x20, 0x20, 0xE0, 0xC0, 0x1E, 0x1E, 0x04, 0x04, 0x06, 0x02, // 222
    0xF0, 0xF8, 0xC8, 0xF8, 0x30, 0x00, 0x1E, 0x1E, 0x00, 0x12, 0x1E, 0x0C, // 223
    0x40, 0x48, 0xD8, 0x80, 0x1C, 0x12, 0x1E, 0x1E, // 224
    0x40, 0x58, 0xC8, 0x80, 0x1C, 0x12, 0x1E, 0x1E, // 225
    0x50, 0x58, 0xC8, 0x98, 0x10, 0x1C, 0x12, 0x1E, 0x1E, 0x00, // 226
    0x58, 0x48, 0xD0, 0x98, 0x1C, 0x12, 0x1E, 0x1E, // 227
    0x50, 0x40, 0xD0, 0x80, 0x1C, 0x12, 0x1E, 0x1E, // 228
    0x40, 0x58, 0xD8, 0x80, 0x1C, 0x12, 0x1E, 0x1E, // 229
    0x40, 0x40, 0x40, 0xC0, 0xC0, 0x40, 0xC0, 0x80, 0x1C, 0x1E, 0x12, 0x0E, 0x1E, 0x12, 0x1A, 0x0A, // 230
    0x80, 0xC0, 0x40, 0x80, 0xAE, 0xBE, 0xF0, 0x08, // 231
    0x80, 0xC8, 0x58, 0x80, 0x0E, 0x1E, 0x12, 0x0A, // 232
    0x80, 0xD8, 0x48, 0x80, 0x0E, 0x1E, 0x12, 0x0A, // 233
    0x90, 0xD8, 0x48, 0x98, 0x10, 0x0E, 0x1E, 0x12, 0x0A, 0x00, // 234
    0x90, 0xC0, 0x50, 0x80, 0x0E, 0x1E, 0x12, 0x0A, // 235
    0xC8, 0xD8, 0x1E, 0x1E, // 236
    0xD8, 0xC8, 0x1E, 0x1E, // 237
    0xD8, 0xC8, 0x18, 0x1E, 0x1E, 0x00, // 238
    0xC0, 0xD0, 0x1E, 0x1E, // 239
    0x80, 0xE0, 0x58, 0xF8, 0xC0, 0x0E, 0x1E, 0x10, 0x1E, 0x0E, // 240
    0xD8, 0xC8, 0x50, 0xD8, 0x80, 0x1E, 0x1E, 0x00, 0x1E, 0x1E, // 241
    0x80, 0xC0, 0x48, 0xD8, 0x80, 0x0E, 0x1E, 0x10, 0x1E, 0x0E, // 242
    0x80, 0xD8, 0x48, 0xC0, 0x80, 0x0E, 0x1E, 0x10, 0x1E, 0x0E, // 243
    0x90, 0xD8, 0x48, 0xD8, 0x90, 0x0E, 0x1E, 0x10, 0x1E, 0x0E, // 244
    0x98, 0xC8, 0x50, 0xD8, 0x80, 0x0E, 0x1E, 0x10, 0x1E, 0x0E, // 245
    0x80, 0xD0, 0x40, 0xD0, 0x80, 0x0E, 0x1E, 0x10, 0x1E, 0x0E, // 246
    0x80, 0x80, 0xA0, 0xA0, 0x80, 0x80, 0x02, 0x02, 0x0A, 0x0A, 0x02, 0x02, // 247
    0x80, 0xC0, 0x40, 0xC0, 0xC0, 0x1E, 0x1E, 0x16, 0x1E, 0x0E, // 248
    0xC0, 0xC0, 0x08, 0xD8, 0xC0, 0x0E, 0x1E, 0x10, 0x1E, 0x1E, // 249
    0xC0, 0xD8, 0x08, 0xC0, 0xC0, 0x0E, 0x1E, 0x10, 0x1E, 0x1E, // 250
    0xD0, 0xD8, 0x08, 0xD8, 0xD0, 0x0E, 0x1E, 0x10, 0x1E, 0x1E // 251
    
};

#endif
